/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.client.gui;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.client.base.RenderHelper;
import codersafterdark.reskillable.client.gui.GuiSkills;
import codersafterdark.reskillable.client.gui.button.GuiButtonLevelUp;
import codersafterdark.reskillable.client.gui.handler.InventoryTabHandler;
import codersafterdark.reskillable.client.gui.handler.KeyBindings;
import codersafterdark.reskillable.network.MessageLevelUp;
import codersafterdark.reskillable.network.MessageUnlockUnlockable;
import codersafterdark.reskillable.network.PacketHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSkillInfo
extends GuiScreen {
    public static final ResourceLocation SKILL_INFO_RES = new ResourceLocation("reskillable", "textures/gui/skill_info.png");
    public static final ResourceLocation SKILL_INFO_RES2 = new ResourceLocation("reskillable", "textures/gui/skill_info2.png");
    private final Skill skill;
    private int guiWidth;
    private int guiHeight;
    private ResourceLocation sprite;
    private GuiButtonLevelUp levelUpButton;
    private Unlockable hoveredUnlockable;
    private boolean canPurchase;

    public GuiSkillInfo(Skill skill) {
        this.skill = skill;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (keyCode == KeyBindings.openGUI.func_151463_i() || keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r != null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void func_73866_w_() {
        this.guiWidth = 176;
        this.guiHeight = 166;
        int left = this.field_146294_l / 2 - this.guiWidth / 2;
        int top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.field_146292_n.clear();
        if (ConfigHandler.enableLevelUp && this.skill.hasLevelButton()) {
            this.levelUpButton = new GuiButtonLevelUp(left + 147, top + 10);
            this.field_146292_n.add(this.levelUpButton);
        }
        InventoryTabHandler.addTabs(this, this.field_146292_n);
        this.sprite = this.skill.getBackground();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int left = this.field_146294_l / 2 - this.guiWidth / 2;
        int top = this.field_146295_m / 2 - this.guiHeight / 2;
        PlayerData data = PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g);
        PlayerSkillInfo skillInfo = data.getSkillInfo(this.skill);
        this.field_146297_k.field_71446_o.func_110577_a(this.sprite);
        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.drawTexturedRec(left + 16 + i * 16, top + 33 + j * 16, 16, 16);
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (ConfigHandler.enableLevelUp && this.skill.hasLevelButton()) {
            this.field_146297_k.field_71446_o.func_110577_a(SKILL_INFO_RES);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(SKILL_INFO_RES2);
        }
        this.func_73729_b(left, top, 0, 0, this.guiWidth, this.guiHeight);
        GuiSkills.drawSkill(left + 4, top + 9, this.skill);
        String levelStr = String.format("%d/%d [ %s ]", skillInfo.getLevel(), this.skill.getCap(), new TextComponentTranslation("reskillable.rank." + skillInfo.getRank(), new Object[0]).func_150261_e());
        this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.BOLD + this.skill.getName(), left + 22, top + 8, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(levelStr, left + 22, top + 18, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(new TextComponentTranslation("reskillable.misc.skill_points", new Object[]{skillInfo.getSkillPoints()}).func_150261_e(), left + 15, top + 154, 0x404040);
        int cost = skillInfo.getLevelUpCost();
        String costStr = Integer.toString(cost);
        if (skillInfo.isCapped()) {
            costStr = new TextComponentTranslation("reskillable.misc.capped", new Object[0]).func_150261_e();
        }
        if (ConfigHandler.enableLevelUp && this.skill.hasLevelButton()) {
            this.func_73732_a(this.field_146297_k.field_71466_p, costStr, left + 138, top + 13, 11534082);
            this.levelUpButton.setCost(cost);
        }
        this.hoveredUnlockable = null;
        this.skill.getUnlockables().forEach(u -> this.drawUnlockable(data, skillInfo, (Unlockable)u, mouseX, mouseY));
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoveredUnlockable != null) {
            this.makeUnlockableTooltip(data, skillInfo, mouseX, mouseY);
        }
    }

    public void drawTexturedRec(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawUnlockable(PlayerData data, PlayerSkillInfo info, Unlockable unlockable, int mx, int my) {
        int x = this.field_146294_l / 2 - this.guiWidth / 2 + 20 + unlockable.getX() * 28;
        int y = this.field_146295_m / 2 - this.guiHeight / 2 + 37 + unlockable.getY() * 28;
        this.field_146297_k.field_71446_o.func_110577_a(SKILL_INFO_RES);
        boolean unlocked = info.isUnlocked(unlockable);
        int u = 0;
        int v = this.guiHeight;
        if (unlockable.hasSpikes()) {
            u += 26;
        }
        if (unlocked) {
            v += 26;
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x, y, u, v, 26, 26);
        this.field_146297_k.field_71446_o.func_110577_a(unlockable.getIcon());
        GuiSkillInfo.func_146110_a((int)(x + 5), (int)(y + 5), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        if (mx >= x && my >= y && mx < x + 26 && my < y + 26) {
            this.canPurchase = !unlocked && info.getSkillPoints() >= unlockable.getCost();
            this.hoveredUnlockable = unlockable;
        }
    }

    private void makeUnlockableTooltip(PlayerData data, PlayerSkillInfo info, int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        TextFormatting tf = this.hoveredUnlockable.hasSpikes() ? TextFormatting.AQUA : TextFormatting.YELLOW;
        tooltip.add(tf + this.hoveredUnlockable.getName());
        if (GuiSkillInfo.func_146272_n()) {
            this.addLongStringToTooltip(tooltip, this.hoveredUnlockable.getDescription(), this.guiWidth);
        } else {
            tooltip.add(TextFormatting.GRAY + new TextComponentTranslation("reskillable.misc.shift", new Object[0]).func_150261_e());
            tooltip.add("");
        }
        if (!info.isUnlocked(this.hoveredUnlockable)) {
            this.hoveredUnlockable.getRequirements().addRequirementsToTooltip(data, tooltip);
        } else {
            tooltip.add(TextFormatting.GREEN + new TextComponentTranslation("reskillable.misc.unlocked", new Object[0]).func_150261_e());
        }
        tooltip.add(TextFormatting.GRAY + new TextComponentTranslation("reskillable.misc.skill_points", new Object[]{this.hoveredUnlockable.getCost()}).func_150261_e());
        RenderHelper.renderTooltip(mouseX, mouseY, tooltip);
    }

    private void addLongStringToTooltip(List<String> tooltip, String longStr, int maxLen) {
        String[] tokens = longStr.split(" ");
        String curr = TextFormatting.GRAY.toString();
        int i = 0;
        while (i < tokens.length) {
            while (this.field_146289_q.func_78256_a(curr) < maxLen && i < tokens.length) {
                curr = curr + tokens[i] + ' ';
                ++i;
            }
            tooltip.add(curr);
            curr = TextFormatting.GRAY.toString();
        }
        tooltip.add(curr);
    }

    protected void func_146284_a(GuiButton button) {
        if (ConfigHandler.enableLevelUp && this.skill.hasLevelButton() && button == this.levelUpButton) {
            MessageLevelUp message = new MessageLevelUp(this.skill.getRegistryName());
            PacketHandler.INSTANCE.sendToServer((IMessage)message);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.hoveredUnlockable != null && this.canPurchase) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            MessageUnlockUnlockable message = new MessageUnlockUnlockable(this.skill.getRegistryName(), this.hoveredUnlockable.getRegistryName());
            PacketHandler.INSTANCE.sendToServer((IMessage)message);
        } else if (mouseButton == 1 || mouseButton == 3) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiSkills());
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

